<%@ Control Language="VB" AutoEventWireup="false" CodeFile="ShoppingCartView.ascx.vb"
  Inherits="ShoppingCartView" %>
<asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataSourceID="odsShoppingCart"
  DataKeyNames="Id" ShowFooter="True" GridLines="Horizontal"
  BorderStyle="Solid" BorderWidth="1px">
  <Columns>
    <asp:BoundField DataField="Title" HeaderText="Nazwa" ReadOnly="True" SortExpression="Title">
      <ItemStyle Width="200px" />
      <HeaderStyle HorizontalAlign="Left" />
    </asp:BoundField>
    <asp:ImageField DataImageUrlField="PictureUrlSmall" ShowHeader="False" ReadOnly="True">
    </asp:ImageField>
    <asp:TemplateField HeaderText="Ilo" SortExpression="Quantity">
      <ItemTemplate>
        <asp:Label ID="lblQuantity" runat="server" Text='<%# Eval("Quantity") %>'></asp:Label>
      </ItemTemplate>
      <EditItemTemplate>
        <asp:DropDownList ID="lstQuantity" runat="server" SelectedValue='<%# Eval("Quantity") %>'
          AutoPostBack="True" OnSelectedIndexChanged="lstQuantity_SelectedIndexChanged">
          <asp:ListItem Value="1" Selected="True">1</asp:ListItem>
          <asp:ListItem Value="2">2</asp:ListItem>
          <asp:ListItem Value="3">3</asp:ListItem>
          <asp:ListItem Value="4">4</asp:ListItem>
          <asp:ListItem Value="5">5</asp:ListItem>
          <asp:ListItem Value="6">6</asp:ListItem>
          <asp:ListItem Value="7">7</asp:ListItem>
          <asp:ListItem Value="8">8</asp:ListItem>
          <asp:ListItem Value="9">9</asp:ListItem>
          <asp:ListItem Value="10">10</asp:ListItem>
        </asp:DropDownList>
      </EditItemTemplate>
      <ItemStyle HorizontalAlign="Right" Width="70px" />
      <HeaderStyle HorizontalAlign="Right" />
    </asp:TemplateField>
    <asp:BoundField DataField="Price" HeaderText="Cena" HtmlEncode="False" ReadOnly="True" SortExpression="Price"
      DataFormatString="{0:c}">
      <ItemStyle HorizontalAlign="Right" Width="75px" />
      <HeaderStyle HorizontalAlign="Right" />
    </asp:BoundField>
    <asp:BoundField DataField="SubTotal" HeaderText="Suma czciowa" HtmlEncode="False" ReadOnly="True" SortExpression="SubTotal"
      DataFormatString="{0:c}">
      <ItemStyle HorizontalAlign="Right" Width="125px" />
      <HeaderStyle HorizontalAlign="Right" />
    </asp:BoundField>
    <asp:TemplateField ShowHeader="False">
      <ItemTemplate>
        <asp:Button ID="LinkButton1" runat="server" CausesValidation="False" CommandName="Edit"
          Text="Edytuj"></asp:Button>
      </ItemTemplate>
      <EditItemTemplate>
        <asp:Button ID="LinkButton2" runat="server" CausesValidation="False" CommandName="Cancel"
          Text="Anuluj"></asp:Button>
      </EditItemTemplate>
      <ItemStyle Width="100px" HorizontalAlign="Center" />
    </asp:TemplateField>
    <asp:TemplateField ShowHeader="False">
      <ItemStyle HorizontalAlign="Center" Width="100px" />
      <ItemTemplate>
        <asp:Button ID="btnDelete" runat="server" CausesValidation="False" CommandName="Delete" Text="Usu" OnClientClick="return confirm('Czy na pewno chcesz usun ten produkt z koszyka?');" />
      </ItemTemplate>
    </asp:TemplateField>
  </Columns>
  <RowStyle BackColor="White" ForeColor="#333333" />
  <HeaderStyle BackColor="#FFB49F" Font-Bold="True" ForeColor="Black" />
</asp:GridView>
<asp:ObjectDataSource ID="odsShoppingCart" runat="server" 
  TypeName="ShopManager" DeleteMethod="RemoveProductFromCart"
  SelectMethod="GetShoppingCartItems" UpdateMethod="UpdateProductInCart">
  <UpdateParameters>
    <asp:Parameter Name="newQuantity" Type="Int32" />
  </UpdateParameters>
</asp:ObjectDataSource>
